//Filter Conversion using Bilinear Transformation Method
//OS:Windows 10
//Scilab 5.5.2

clear all;
clc;
close;

ap = input('Enter value of ap in dB')
as = input('Enter value of as in dB')
fp = input('Enter value of fp in Hz')
fs = input('Enter value of fs in Hz')
f = input('Enter value of f')

T=1/f;
wp =2*%pi*fp;
ws =2*%pi*fs;
op =2/T*tan(wp*T/2);
os =2/T*tan(ws*T/2);
N= log(sqrt((10^(0.1*as)-1)/(10^(0.1*ap)-1)))/log(op/os);
disp(ceil(N),' Order of the filter , N =');
s=%s;
HS =1/(s+1) // Transfer Function for N=1
oc=op //rad/sec
HS1 = horner(HS,oc/s);
disp(HS1,'Normalized Transfer Function , H(s) =');
z=%z;
HZ= horner(HS,(2/T)*(z-1)/(z+1));
disp(HZ,'H(z)=');

//Example Input
//Enter value of ap in dB 3
//Enter value of as in dB 10
//Enter value of fp in Hz 1000
//Enter value of fs in Hz 350
//Enter value of f 5000
//Order of the filter , N =   1.
// Normalized Transfer Function , H(s) =
//         s         
//   --------------  
//                   
//   7265.4253 + s   
// H(z)=                  
//       1 + z        
//   ---------------  
//                    
//   -9999 + 10001z   
